<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('invoice_bom_components', function (Blueprint $table) {
            $table->id();
            $table->string('component_name')->unique(); // Nama component custom
            $table->json('component_structure'); // Struktur component (Core, Veneer, etc.)
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invoice_bom_components');
    }
};