<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('product_veneers', function (Blueprint $table) {
            $table->id();
            $table->string('veneer_type'); // MAHONI, WHITE BEECH, etc.
            $table->decimal('thickness', 8, 2); // Tebal (0.5)
            $table->decimal('price_lurus', 15, 2); // Harga Lurus per M2
            $table->decimal('price_motif', 15, 2); // Harga Motif per M2
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_veneers');
    }
};