<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceStone extends Model
{
    use HasFactory;

    protected $fillable = [
        'invoice_bom_id',
        'stone_data',
        'grand_total',
    ];

    protected $casts = [
        'stone_data' => 'array',
        'grand_total' => 'decimal:2',
    ];

    /**
     * Relationship: Belongs to InvoiceBom
     */
    public function invoiceBom()
    {
        return $this->belongsTo(InvoiceBom::class);
    }

    /**
     * Get Stone Items from JSON
     */
    public function getStoneItems()
    {
        if (!$this->stone_data) {
            return [];
        }

        $data = is_string($this->stone_data) 
            ? json_decode($this->stone_data, true) 
            : $this->stone_data;

        return $data['items'] ?? [];
    }

    /**
     * Calculate Grand Total from Items
     */
    public function calculateGrandTotal()
    {
        $items = $this->getStoneItems();
        
        return collect($items)->sum('total');
    }
}