<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceFitting extends Model
{
    use HasFactory;

    // ✅ Specify table name (singular)
    protected $table = 'invoice_fitting';

    protected $fillable = [
        'invoice_bom_id',
        'fitting_data',
        'grand_total',
    ];

    protected $casts = [
        'fitting_data' => 'array',
        'grand_total' => 'decimal:2',
    ];

    // Relationship
    public function invoiceBom()
    {
        return $this->belongsTo(InvoiceBom::class);
    }

    /**
     * Get Fitting Groups from JSON
     */
    public function getFittingGroups()
    {
        if (!$this->fitting_data) {
            return [];
        }

        // Parse JSON jika masih string
        $data = is_string($this->fitting_data) 
            ? json_decode($this->fitting_data, true) 
            : $this->fitting_data;

        return $data['groups'] ?? [];
    }

    /**
     * Calculate Grand Total from Groups
     */
    public function calculateGrandTotal()
    {
        $groups = $this->getFittingGroups();
        
        return collect($groups)->sum('subtotal');
    }
}