<?php

namespace App\Http\Controllers\Product;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ProductVeneer;
use Illuminate\Support\Facades\Validator;

class ProductVeneerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $veneers = ProductVeneer::orderBy('veneer_type')->get();
        return view('product.veneer.index', compact('veneers'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('product.veneer.crud', ['veneer' => null]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'veneer_type' => 'required|string',
            'thickness' => 'required|numeric|min:0',
            'price_lurus' => 'required|numeric|min:0',
            'price_motif' => 'required|numeric|min:0',
        ], [
            'veneer_type.required' => 'Tipe veneer harus diisi',
            'thickness.required' => 'Tebal harus diisi',
            'thickness.numeric' => 'Tebal harus berupa angka',
            'thickness.min' => 'Tebal tidak boleh negatif',
            'price_lurus.required' => 'Harga lurus harus diisi',
            'price_lurus.numeric' => 'Harga lurus harus berupa angka',
            'price_lurus.min' => 'Harga lurus tidak boleh negatif',
            'price_motif.required' => 'Harga motif harus diisi',
            'price_motif.numeric' => 'Harga motif harus berupa angka',
            'price_motif.min' => 'Harga motif tidak boleh negatif',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        ProductVeneer::create($request->all());

        return redirect()->route('product.veneer.index')
            ->with('success', 'Product Veneer berhasil ditambahkan!');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $veneer = ProductVeneer::findOrFail($id);
        return view('product.veneer.crud', compact('veneer'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'veneer_type' => 'required|string',
            'thickness' => 'required|numeric|min:0',
            'price_lurus' => 'required|numeric|min:0',
            'price_motif' => 'required|numeric|min:0',
        ], [
            'veneer_type.required' => 'Tipe veneer harus diisi',
            'thickness.required' => 'Tebal harus diisi',
            'thickness.numeric' => 'Tebal harus berupa angka',
            'thickness.min' => 'Tebal tidak boleh negatif',
            'price_lurus.required' => 'Harga lurus harus diisi',
            'price_lurus.numeric' => 'Harga lurus harus berupa angka',
            'price_lurus.min' => 'Harga lurus tidak boleh negatif',
            'price_motif.required' => 'Harga motif harus diisi',
            'price_motif.numeric' => 'Harga motif harus berupa angka',
            'price_motif.min' => 'Harga motif tidak boleh negatif',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $veneer = ProductVeneer::findOrFail($id);
        $veneer->update($request->all());

        return redirect()->route('product.veneer.index')
            ->with('success', 'Product Veneer berhasil diupdate!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $veneer = ProductVeneer::findOrFail($id);
        $veneer->delete();

        return redirect()->route('product.veneer.index')
            ->with('success', 'Product Veneer berhasil dihapus!');
    }
}