<?php

namespace App\Http\Controllers\Product;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ProductPanel;
use Illuminate\Support\Facades\Validator;

class ProductPanelController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $panels = ProductPanel::orderBy('panel_type')->orderBy('thickness')->get();
        return view('product.panel.index', compact('panels'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('product.panel.crud', ['panel' => null]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'panel_type' => 'required|string|in:PB,MDF,PLYWOOD',
            'thickness' => 'required|numeric|min:0',
            'price' => 'required|numeric|min:0',
        ], [
            'panel_type.required' => 'Tipe panel harus diisi',
            'panel_type.in' => 'Tipe panel harus PB, MDF, atau PLYWOOD',
            'thickness.required' => 'Tebal harus diisi',
            'thickness.numeric' => 'Tebal harus berupa angka',
            'thickness.min' => 'Tebal tidak boleh negatif',
            'price.required' => 'Harga harus diisi',
            'price.numeric' => 'Harga harus berupa angka',
            'price.min' => 'Harga tidak boleh negatif',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        ProductPanel::create($request->all());

        return redirect()->route('product.panel.index')
            ->with('success', 'Product Panel berhasil ditambahkan!');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $panel = ProductPanel::findOrFail($id);
        return view('product.panel.crud', compact('panel'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'panel_type' => 'required|string|in:PB,MDF,PLYWOOD',
            'thickness' => 'required|numeric|min:0',
            'price' => 'required|numeric|min:0',
        ], [
            'panel_type.required' => 'Tipe panel harus diisi',
            'panel_type.in' => 'Tipe panel harus PB, MDF, atau PLYWOOD',
            'thickness.required' => 'Tebal harus diisi',
            'thickness.numeric' => 'Tebal harus berupa angka',
            'thickness.min' => 'Tebal tidak boleh negatif',
            'price.required' => 'Harga harus diisi',
            'price.numeric' => 'Harga harus berupa angka',
            'price.min' => 'Harga tidak boleh negatif',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $panel = ProductPanel::findOrFail($id);
        $panel->update($request->all());

        return redirect()->route('product.panel.index')
            ->with('success', 'Product Panel berhasil diupdate!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $panel = ProductPanel::findOrFail($id);
        $panel->delete();

        return redirect()->route('product.panel.index')
            ->with('success', 'Product Panel berhasil dihapus!');
    }
}