<?php

namespace App\Http\Controllers\Product;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\MaterialSolid;
use Illuminate\Support\Facades\Validator;

class MaterialSolidController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $materials = MaterialSolid::orderBy('material_name')->get();
        return view('product.material.index', compact('materials'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('product.material.crud', ['material' => null]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'material_name' => 'required|string',
            'price' => 'required|numeric|min:0',
        ], [
            'material_name.required' => 'Nama material harus diisi',
            'price.required' => 'Harga harus diisi',
            'price.numeric' => 'Harga harus berupa angka',
            'price.min' => 'Harga tidak boleh negatif',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        MaterialSolid::create($request->all());

        return redirect()->route('material.solid.index')
            ->with('success', 'Material Solid berhasil ditambahkan!');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $material = MaterialSolid::findOrFail($id);
        return view('product.material.crud', compact('material'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'material_name' => 'required|string',
            'price' => 'required|numeric|min:0',
        ], [
            'material_name.required' => 'Nama material harus diisi',
            'price.required' => 'Harga harus diisi',
            'price.numeric' => 'Harga harus berupa angka',
            'price.min' => 'Harga tidak boleh negatif',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $material = MaterialSolid::findOrFail($id);
        $material->update($request->all());

        return redirect()->route('material.solid.index')
            ->with('success', 'Material Solid berhasil diupdate!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $material = MaterialSolid::findOrFail($id);
        $material->delete();

        return redirect()->route('material.solid.index')
            ->with('success', 'Material Solid berhasil dihapus!');
    }
}