<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\InvoiceBom;
use App\Models\ProductPanel;
use App\Models\ProductSolid;
use App\Models\ProductVeneer;
use App\Models\ProductDrawer;

class DashboardController extends Controller
{
    /**
     * Display dashboard
     */
    public function index()
    {
        $data = [
            'total_invoices' => InvoiceBom::count(),
            'total_panels' => ProductPanel::count(),
            'total_solids' => ProductSolid::count(),
            'total_veneers' => ProductVeneer::count(),
            'total_drawers' => ProductDrawer::count(),
            'recent_invoices' => InvoiceBom::latest()->take(5)->get(),
        ];

        return view('dashboard.index', $data);
    }
}